from pydantic import BaseModel

class BannerCreate(BaseModel):
    title: str
    image_url: str

class BannerOut(BannerCreate):
    id: int
    class Config:
        orm_mode = True

class GalleryCreate(BaseModel):
    image_url: str
    description: str

class GalleryOut(GalleryCreate):
    id: int
    class Config:
        orm_mode = True



class ContactCreate(BaseModel):
    name: str
    email: str
    phone: str
    message: str

class ContactOut(ContactCreate):
    id: int
    class Config:
        orm_mode = True

class UserCreate(BaseModel):
    name: str
    email: str
    password: str

class UserLogin(BaseModel):
    email: str
    password: str

class UserOut(BaseModel):
    id: int
    name: str
    email: str
    class Config:
        orm_mode = True

class ServiceBase(BaseModel):
    title: str
    description: str
    image_url: str

class ServiceCreate(ServiceBase):
    pass

class ServiceUpdate(BaseModel):
    title: str
    description: str

class ServiceOut(ServiceBase):
    id: int

    class Config:
        orm_mode = True